/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import javax.jms.JMSException;
import javax.jms.TemporaryQueue;

/**
 * This class implements javax.jms.TemporaryQueue
 *
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.3.4.2 $
 */
public class SpyTemporaryQueue extends SpyQueue implements TemporaryQueue
{
   // Constants -----------------------------------------------------

   /** The serialVersionUID */
   static final long serialVersionUID = 1216493383395688001L;
   
   // Attributes ----------------------------------------------------
   
   /** The DistributedConnection of its creator */
   ConnectionToken dc;

   /** Connection to the creator used from the client side */
   private transient Connection con = null;
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new SpyTemporaryQueue
    *
    * @param queueName the queue name
    * @param dc_ the connection token
    */
   public SpyTemporaryQueue(String queueName, ConnectionToken dc_)
   {
      super(queueName);
      dc = dc_;
   }
   
   // Public --------------------------------------------------------

   /**
    * Client-side temporary queues need a reference to the connection that
    * created them in case delete() is called.
    * 
    * @param con the connection
    */
   public void setConnection(Connection con)
   {
      this.con = con;
   }
   
   // TemporaryQueue implementation ---------------------------------

   public void delete() throws JMSException
   {
      try
      {
         con.deleteTemporaryDestination(this);
      }
      catch (Exception e)
      {
         throw new SpyJMSException("Cannot delete the TemporaryQueue", e);
      }
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}