/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import javax.jms.JMSException;
import javax.jms.TopicSession;
import javax.jms.XATopicSession;

/**
 * This class implements <tt>javax.jms.TopicSession</tt> and <tt>javax.jms.XATopicSession</tt>.
 *
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.7.2.2 $
 */
public class SpyTopicSession extends SpySession implements TopicSession, XATopicSession
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new SpyTopicSession
    *
    */
   SpyTopicSession(Connection myConnection, boolean transacted, int acknowledgeMode)
   {
      this(myConnection, transacted, acknowledgeMode, false);
   }

   /**
    * Create a new SpyTopicSession
    *
    * @param myConnection the connection
    * @param transacted true for transacted, false otherwise
    * @param acknowledgeMode the acknowledgement mode
    * @param xaSession true for xa, false otherwise
    */
   SpyTopicSession(Connection myConnection, boolean transacted, int acknowledgeMode, boolean xaSession)
   {
      super(myConnection, transacted, acknowledgeMode, xaSession);
   }
   
   // Public --------------------------------------------------------
   
   // TopicXASession implementation ---------------------------------

   public TopicSession getTopicSession() throws JMSException
   {
      return this;
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}