/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import java.io.Serializable;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;

/**
 * This class implements javax.jms.XAQueueConnection
 * 
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.4.2.2 $
 */
public class SpyXAConnection extends SpyConnection implements Serializable, XAConnection, XATopicConnection, XAQueueConnection
{
   // Constants -----------------------------------------------------

   /** The serialVersionUID */
   static final long serialVersionUID = 1258716704996031025L;
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new SpyXAConnection
    *
    * @param userid the user
    * @param password the password
    * @param gcf the constructing class
    * @throws JMSException for any error
    */
   public SpyXAConnection(String userid, String password, GenericConnectionFactory gcf) throws JMSException
   {
      super(userid, password, gcf);
   }

   /**
    * Create a new SpyXAConnection
    *
    * @param gcf the constructing class
    * @throws JMSException for any error
    */
   public SpyXAConnection(GenericConnectionFactory gcf) throws JMSException
   {
      super(gcf);
   }
   
   // Public --------------------------------------------------------
   
   // Connection overrides ------------------------------------------
   
   public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException
   {
      return (QueueSession) createXASession();
   }
   
   public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException
   {
      return (QueueSession) createXAQueueSession();
   }

   public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException
   {
      return (TopicSession) createXATopicSession();
   }
   
   // XAConnection implementation -----------------------------------

   public XASession createXASession() throws JMSException
   {
      if (closed)
         throw new IllegalStateException("The connection is closed");
      checkClientID();

      XASession session = new SpySession(this, true, 0, true);
      //add the new session to the createdSessions list
      synchronized (createdSessions)
      {
         createdSessions.add(session);
      }
      return session;
   }

   public XAQueueSession createXAQueueSession() throws JMSException
   {
      if (closed)
         throw new IllegalStateException("The connection is closed");
      checkClientID();

      XAQueueSession session = new SpyQueueSession(this, true, 0, true);

      //add the new session to the createdSessions list
      synchronized (createdSessions)
      {
         createdSessions.add(session);
      }

      return session;
   }

   public XATopicSession createXATopicSession() throws javax.jms.JMSException
   {
      if (closed)
         throw new IllegalStateException("The connection is closed");
      checkClientID();

      XATopicSession session = new SpyTopicSession(this, true, 0, true);
      //add the new session to the createdSessions list
      synchronized (createdSessions)
      {
         createdSessions.add(session);
      }
      return session;
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}