/*
 * JBossMQ, the OpenSource JMS implementation
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mq.pm;

import javax.jms.JMSException;

import org.jboss.mq.SpyMessage;

/**
 * New Persistence Manager interface
 *
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.1.2.3 $
 */
public interface NewPersistenceManager
   extends PersistenceManager
{
   // Constants -----------------------------------------------------

   // Public --------------------------------------------------------

   /**
    * Persist the message
    * 
    * @param message the message to persist
    * @throws JMSException for any error
    */
   void addMessage(SpyMessage message) throws JMSException;
}
