/*
 * JBossMQ, the OpenSource JMS implementation
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mq.server;

import javax.jms.DeliveryMode;
import javax.jms.JMSException;

import org.jboss.mq.ConnectionToken;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.TransactionRequest;

/**
 * Makes all messages Non Persistent
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1.2.1 $
 */
public class NonPersistentInterceptor extends JMSServerInterceptorSupport
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   // Public --------------------------------------------------------

   // JMSServerInterceptorSupport overrides -------------------------

   public void addMessage(ConnectionToken dc, SpyMessage message) throws JMSException
   {
      makeNonPersistent(message);
      super.addMessage(dc, message);
   }

   public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException
   {
      if (t.messages != null)
      {
         for (int i = 0; i < t.messages.length; ++i)
            makeNonPersistent(t.messages[i]);
      }
      super.transact(dc, t);
   }
   
   // Protected -----------------------------------------------------

   /**
    * Overrides the message to be Non Persistent
    * 
    * @param message the message
    * @throws JMSException for any error
    */
   protected void makeNonPersistent(SpyMessage message) throws JMSException
   {
      message.setJMSDeliveryMode(DeliveryMode.NON_PERSISTENT);
   }
   
   // Package Private -----------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
