/*
 * JBossMQ, the OpenSource JMS implementation
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mq.server;

import java.util.ArrayList;
import java.util.Iterator;

import org.jboss.mq.Subscription;

/**
 * Interface to be implemented by a receivers implementation.
 * The implementation should also have a default constructor.
 * NOTE: There is no need to internally synchronize the caller
 * handles that.
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1.2.1 $
 */
public interface Receivers
{
   // Constants -----------------------------------------------------

   // Public --------------------------------------------------------

   /**
    * @return Get the number of receivers
    */
   int size();
   
   /**
    * @return the subscriptions as an array list, this must be a
    * clone of any internal datastructure
    */
   ArrayList listReceivers();
   
   
   /**
    * Add a receiver
    * 
    * @param sub the receiver to add
    */
   void add(Subscription sub);
   
   /**
    * Remove a receiver
    * 
    * @param sub the receiver to remove
    */
   void remove(Subscription sub);
   
   /**
    * Get an iterator to loop over all receivers
    * 
    * @return the iterator
    */
   Iterator iterator();
   
   // Inner classes -------------------------------------------------
}
