/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

import java.util.Map;
import java.io.Serializable;

/**
 * InvocationRequest is passed to ServerInvocationHandler which encapsulates the
 * unmarshalled method invocation parameters from the ServerInvoker.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.5 $
 */
//TODO: Need to remove Serializable if not going to pass InvocationRequest as the callback object -TME
public class InvocationRequest implements Serializable
{
    private String sessionId;

    private String subsystem;
    private Object arg;
    private Map requestPayload;
    private Map returnPayload;
    private InvokerLocator locator;

    public InvocationRequest ( String sessionId, String subsystem, Object arg, Map requestPayload, Map returnPayload, InvokerLocator locator )
    {
        this.sessionId = sessionId;
        this.subsystem = subsystem;
        this.arg = arg;
        this.requestPayload = requestPayload;
        this.returnPayload = returnPayload;
        this.locator = locator;
    }

    public InvokerLocator getLocator ()
    {
        return locator;
    }

    public void setLocator (InvokerLocator locator)
    {
        this.locator = locator;
    }

    public String getSubsystem ()
    {
        return subsystem;
    }

    public void setSubsystem ( String subsystem )
    {
        this.subsystem = subsystem;
    }

    public String getSessionId ()
    {
        return sessionId;
    }

    public void setSessionId ( String sessionId )
    {
        this.sessionId = sessionId;
    }

    public Object getParameter ()
    {
        return arg;
    }

    public void setParameter (Object arg)
    {
        this.arg = arg;
    }

    public Map getRequestPayload ()
    {
        return requestPayload;
    }

    public void setRequestPayload ( Map requestPayload )
    {
        this.requestPayload = requestPayload;
    }

    public Map getReturnPayload ()
    {
        return returnPayload;
    }

    public void setReturnPayload ( Map returnPayload )
    {
        this.returnPayload = returnPayload;
    }
}
