/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.lang.reflect.Proxy;

import org.jboss.remoting.loading.ClassBytes;

/**
 * RemoteMethodInvocation is a serialized object that contains the remote method, arguments, signature and
 * associated data necessary for a remote ServerInvoker to transport an invocation.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.7 $
 */
public class RemoteMethodInvocation implements Serializable
{
   private String sessionId;
   private ClassBytes param;
   private ClassBytes classbytes[];
   private String subsystem;
   private Map payload;
   private InvokerLocator locator;


   public RemoteMethodInvocation (String sessionId, String subsystem, Object arg, Map payload, InvokerLocator locator)
      throws IOException
   {
      this.sessionId = sessionId;
      this.subsystem = subsystem;
      this.payload = payload;
      this.locator = locator;
      if (arg!=null)
      {
         ByteArrayOutputStream bos=new ByteArrayOutputStream();

         byte data[]=null;
         String cn = null;
         ObjectOutputStream oos=new ObjectOutputStream(bos);
         oos.writeObject(arg);
         oos.flush();
         data=bos.toByteArray();
         if (Proxy.isProxyClass(arg.getClass()))
         {
            // just get the first interface in the list
            cn = arg.getClass().getInterfaces()[0].getName();
         }
         else
         {
            cn = arg.getClass().getName();
         }
         // note: we want to use the actual class name, not the signature
         // since the resolveClass needs the real class not the signature
         param = new org.jboss.remoting.loading.ClassBytes(cn,data);
      }
   }

   public String getSubsystem ()
   {
      return subsystem;
   }
   public void setSubsystem (String sub)
   {
      this.subsystem = sub;
   }
   public String toString ()
   {
      return org.jboss.remoting.loading.ClassUtil.getShortClassName(this.getClass()) +" [sessionId:"+sessionId+",subsystem:"+subsystem+",locator:"+locator+"]";
   }
   public String getSessionId ()
   {
      return sessionId;
   }
   public ClassBytes getParameter ()
   {
      return param;
   }
   public Map getPayload ()
   {
      return this.payload;
   }
   public void setPayload (Map payload)
   {
      this.payload = payload;
   }
   public void setClassBytes (ClassBytes bytes[])
   {
      this.classbytes = bytes;
   }
   /**
    * return the locator (client) that invoked this method (on server)
    *
    * @return
    */
   public InvokerLocator getLocator ()
   {
      return locator;
   }

   public ClassBytes[] getClassBytes ()
   {
      return this.classbytes;
   }

   public byte [] serialize ()
      throws IOException
   {
      return org.jboss.remoting.loading.ClassUtil.serialize(this);
   }
}
