/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.lang.reflect.Proxy;

import org.jboss.remoting.loading.ClassBytes;

/**
 * RemoteMethodInvocationResult is a return object from a call to a remote Server Invoker.
 * The RemoteMethodInvocationResult may contain either an Exception or a result value (which may be
 * null in the case the user returns null)
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.2 $
 */
public class RemoteMethodInvocationResult implements Serializable
{
    static final long serialVersionUID = 1324503813652865685L;

    private final String sessionId;
    private final ClassBytes result;
    private final boolean isException;
    private Map payload;

    public RemoteMethodInvocationResult (String sessionId, Object result, boolean isException, Map payload)
        throws IOException
    {
        this.sessionId = sessionId;
        this.isException = isException;
        this.payload = payload;
        if (result!=null)
        {
            ByteArrayOutputStream bos=new ByteArrayOutputStream();
            ObjectOutputStream oos=new ObjectOutputStream(bos);
            oos.writeObject(result);
            String name = null;
            if (result!=null)
            {
                if (Proxy.isProxyClass(result.getClass()))
                {
                    name = result.getClass().getInterfaces()[0].getName();
                }
                else
                {
                    name = result.getClass().getName();
                }
            }
            this.result = new org.jboss.remoting.loading.ClassBytes(name,bos.toByteArray());
        }
        else
        {
            this.result = null;
        }
    }
    public String getSessionId ()
    {
        return sessionId;
    }
    public Map getPayload ()
    {
        return payload;
    }
    public boolean isException ()
    {
        return isException;
    }
    public ClassBytes getResult ()
    {
        return result;
    }
    /**
     * convenenience method to return this objects as a serialized byte array
     *
     * @return
     * @throws IOException
     */
    public byte [] serialize ()
        throws IOException
    {
        return org.jboss.remoting.loading.ClassUtil.serialize(this);
    }
}
