/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.detection;

import java.io.Serializable;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;

/**
 * Detection is an MBean Notification that is fired by
 * Detectors when remote servers are found or lost on the Network.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1.4.1 $
 */
public class Detection implements Serializable
{
    static final long serialVersionUID = -8401843787362355866L;
    private final InvokerLocator locators[];
    private final Identity identity;
    private int hashCode;

    public Detection (Identity identity, InvokerLocator locators[])
    {
        this.locators = locators;
        this.identity = identity;
        this.hashCode = identity.hashCode();
        if (locators!=null)
        {
            for (int c=0;c<locators.length;c++)
            {
                this.hashCode+=locators[c].hashCode() - 10000;
            }
        }
    }
    public boolean equals (Object obj)
    {
        if (obj instanceof Detection)
        {
            return hashCode==obj.hashCode();
        }
        return false;
    }
    public int hashCode ()
    {
        return hashCode;
    }

    public String toString ()
    {
        return "Detection [identity:"+identity+",locators:"+(locators==null?0:locators.length)+"]";
    }
    /**
     * return the jboss identity
     *
     * @return
     */
    public final Identity getIdentity ()
    {
        return identity;
    }
    /**
     * return the locators for the server
     *
     * @return
     */
    public final InvokerLocator[] getLocators ()
    {
        return locators;
    }
}
