/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.detection;

import javax.management.MBeanRegistration;
import javax.management.NotificationBroadcaster;

/**
 * Detector
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @version $Revision: 1.1.4.4 $
 */
public interface Detector extends MBeanRegistration, NotificationBroadcaster
{
   /**
    * Key for the notification type when detector finds a new server
    */
   public static final String SERVER_FOUND = "server_found";
   /**
    * Key for the notification type when detector looses a server
    */
   public static final String SERVER_LOST = "server_lost";

   /**
    * Key for the notification type when detector updates a server
    */
   public static final String SERVER_UPDATED = "server_updated";

   /**
    * called by MBeanServer to start the mbean lifecycle
    *
    * @throws Exception
    */
   public void start() throws Exception;

   /**
    * called by the MBeanServer to stop the mbean lifecycle
    *
    * @throws Exception
    */
   public void stop() throws Exception;
}
