/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.detection.multicast;

import java.net.InetAddress;

import org.jboss.remoting.detection.Detector;


/**
 * MulticastDetectorMBean
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.2 $
 */
public interface MulticastDetectorMBean extends Detector
{
    /**
     * return the multicast address of the detector
     *
     * @return
     */
    public InetAddress getAddress ();

    /**
     * set the interface address of the multicast
     *
     * @param ip
     */
    public void setAddress (InetAddress ip);

    /**
     * return the bind address of the detector
     *
     * @return
     */
    public InetAddress getBindAddress();

    /**
     * set the bind address
     *
     * @param ip
     */
    public void setBindAddress(InetAddress ip);

    /**
     * set the port for detections to be multicast to
     *
     * @param port
     */
    public void setPort (int port);

    /**
     * get the port that the detector is multicasting to
     *
     * @return
     */
    public int getPort ();
}
