/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */

package org.jboss.remoting.invocation;

import java.io.Serializable;

/**
 * Serves as the base invocation object for the different types of remoting invocations.
 * All remoting invocations should extend this class (i.e. InternalInvocation, NameBasedInvocation, etc.)
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class RemoteInvocation implements Serializable
{
    protected final String methodName;
    protected final Object[] params;

    public RemoteInvocation(final String methodName, final Object[] params)
    {
       this.methodName = methodName;
       this.params = params;
    }

    public String getMethodName()
    {
       return methodName;
    }

    public Object[] getParameters()
    {
       return params;
    }
}
