/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.network;

import java.io.Serializable;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;

/**
 * NetworkInstance is an object that represents an Identity and its InvokerLocators.
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1 $
 */
public class NetworkInstance implements Serializable
{
    private final Identity identity;
    private final InvokerLocator locators[];
    private final int hashCode;

    public NetworkInstance (Identity identity, InvokerLocator locators[])
    {
       this.identity = identity;
       this.locators = locators;
       this.hashCode = this.identity.hashCode();
    }
    public final Identity getIdentity ()
    {
        return identity;
    }
    public final InvokerLocator [] getLocators ()
    {
        return locators;
    }
    public String toString ()
    {
        return "NetworkInstance [identity:"+identity+",locator count:"+(locators==null?0:locators.length)+"]";
    }
    public boolean equals (Object obj)
    {
       return hashCode==obj.hashCode();
    }
    public int hashCode ()
    {
        return hashCode;
    }
}
