/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.network;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/**
 * NetworkRegistryFinder is a utility class for finding the ObjectName to the NetworkRegistryMBean
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1 $
 */
public class NetworkRegistryFinder 
{
    /**
     * find the ObjectName to the NetworkRegistryMBean instance on the MBeanServer
     *
     * @param server
     * @return
     */
    public static ObjectName find (MBeanServer server)
    {
        Set set = server.queryMBeans(null,new NetworkRegistryQuery());
        if (set.isEmpty())
        {
            return null;
        }
        return ((ObjectInstance)set.iterator().next()).getObjectName();
    }
}
