/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.transport;

import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.Invoker;
import org.jboss.remoting.InvokerLocator;

/**
 * Interface to be used for calling on all the different invoker types (LocalClientInvoker
 * and RemoteClientInvoker).
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 */
public interface ClientInvoker extends Invoker
{
    /**
     * This should be set when want to override the default behavior of automatically
     * getting s suitable locator.  This should be used want want to control what type
     * of callbacks to receive (pull or push).  Set to null to poll for callback messages.
     * This can also be used to receive callbacks using another transport and subsystem,
     * if desired.
     * @param locator
     */
    public void setClientLocator(InvokerLocator locator);

    /**
     * Gets the client locator.  This locator will be used by the server side
     * to make callbacks to the handler for this locator.
     * @return
     */
    public InvokerLocator getClientLocator();

    /**
     * transport a request against a remote ServerInvoker
     *
     * @param in
     * @return
     * @throws Throwable
     */
    public Object invoke(InvocationRequest in) throws Throwable;

    /**
     * subclasses must provide this method to return true if their remote connection is connected and
     * false if disconnected.  in some transports, such as SOAP, this method may always return true, since the
     * remote connectivity is done on demand and not kept persistent like other transports (such as socket-based
     * transport).
     *
     * @return boolean true if connected, false if not
     */
    public boolean isConnected();

    /**
     * connect to the remote invoker
     *
     * @throws org.jboss.remoting.ConnectionFailedException
     */
    public void connect() throws ConnectionFailedException;

    /**
     * disconnect from the remote invoker
     */
    public void disconnect();

    /**
     * return the last invocation timestamp when this invoker successfully invoked a
     * method and it returned w/o connection failure (if the remote side raised an Exception during the
     * normal course of an invocation, the timestamp should be updated).
     *
     * @return
     */
    public long getLastInvocationTimestamp ();

}