/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.remoting.transport.async;

import java.io.IOException;

import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;

/**
 * An AsynchChannel allows you to transport bytes of data
 * back and forth between a client and a server in a async 
 * manner.
 * 
 * This interace abstraction is here so that it can be implemented 
 * using both the Blocking and Non-blocking IO APIs.
 * 
 * @author <a href="mailto:hiram@coredevelopers.net">Hiram Chirino</a>
 */
public interface Channel {
	
	/**
	 * opens a connection to another server.
	 * 
	 * @param uri
	 * @param localURI
	 * @param listner
	 * @throws IOException
	 * @throws ConnectionFailedException
	 */
	public void open(InvokerLocator uri, ChannelListner listner)
		throws IOException, ConnectionFailedException;

	/**
	 * starts an accepted connection.
	 * 
	 * @param listner
	 * @throws IOException
	 */
	public void open(ChannelListner listner)
		throws IOException;


	public void close() throws IOException;

	/**
	 * Sends an asynch packet of data down the channel.  It does not 
	 * wait wait for a response if possible.
	 */
	public void send(byte[][] data) throws IOException;
	
}
