/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.remoting.transport.async;


/**
 * This interface should be implemented by objects that wants to 
 * receive Channel events.
 * 
 * @author <a href="mailto:hiram@coredevelopers.net">Hiram Chirino</a>
 */
public interface ChannelListner
{
   /**
    * Sends an asynch packet of data down the channel.  It does not 
    * wait wait for a response if possible.
    */
   public void receiveEvent(byte []data) throws InterruptedException;
      
   /**
	* The remote end closed the connection.  The receiver of this event
	* should close() the channel.
	*/
   public void closeEvent();

}
