/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.async;

import java.io.IOException;

import org.jboss.remoting.InvokerLocator;

/**
 * An ChannelServer allows you accept incomming Channel connections.
 * The accepted channels just get added to the Registry.
 * 
 * This interace abstraction is here so that it can be implemented 
 * using both the Blocking and Non-blocking IO APIs.
 *
 * @author <a href="mailto:hiram@coredevelopers.net">Hiram Chirino</a>
 */
public interface ChannelServer {

	/**
	 * Binds the server to network resource.  
	 * 
	 * @param localURI
	 * @param listner
	 * @throws IOException
	 */	
	public void bind(InvokerLocator bindURI) throws IOException;

	/**
	 * The URI that the server is bound to.  Asynch channels can be establsihed
	 * to this uri.
	 * @return
	 */
	public InvokerLocator getLocalURI();
	
	/**
	 * Starts the server so that it will accept new
	 * channels.
	 * 
	 */
	public void start() throws IOException;

	/**
	 * Stops the server from accepting any more channels. 
	 */
	public void stop();

	/**
	 * releases all network resources.
	 */
	public void close();

}
