/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.soap.axis;

/**
 * SOAP transport locator
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @author <a href="jhaynie@vocalcoity.net">Jeff Haynie</a>
 */
public class AxisSOAPConnectorServiceLocator extends org.apache.axis.client.Service
        implements AxisSOAPConnectorService
{
    private final String AxisSOAPConnector_address = "http://localhost/axis/services/AxisSOAPConnector";

    public String getAxisSOAPConnectorAddress() {
        return AxisSOAPConnector_address;
    }

    // The WSDD service name defaults to the port name.
    private String AxisSOAPConnectorWSDDServiceName = "AxisSOAPConnector";

    public String getAxisSOAPConnectorWSDDServiceName() {
        return AxisSOAPConnectorWSDDServiceName;
    }

    public void setAxisSOAPConnectorWSDDServiceName(String name) {
        AxisSOAPConnectorWSDDServiceName = name;
    }

    public AxisSOAPConnector getAxisSOAPConnector() throws javax.xml.rpc.ServiceException {
       java.net.URL endpoint;
        try {
            endpoint = new java.net.URL(AxisSOAPConnector_address);
        }
        catch (java.net.MalformedURLException e) {
            return null; // unlikely as URL was validated in WSDL2Java
        }
        return getAxisSOAPConnector(endpoint);
    }

    public AxisSOAPConnector getAxisSOAPConnector(java.net.URL portAddress) throws javax.xml.rpc.ServiceException {
        try {
            AxisSOAPConnectorSoapBindingStub _stub = new AxisSOAPConnectorSoapBindingStub(portAddress, this);
            _stub.setPortName(getAxisSOAPConnectorWSDDServiceName());
            return _stub;
        }
        catch (org.apache.axis.AxisFault e) {
            return null;
        }
    }

    /**
     * For the given interface, get the stub implementation.
     * If this service has no port for the given interface,
     * then ServiceException is thrown.
     */
    public java.rmi.Remote getPort(Class serviceEndpointInterface) throws javax.xml.rpc.ServiceException {
        try {
            if (AxisSOAPConnector.class.isAssignableFrom(serviceEndpointInterface)) {
                AxisSOAPConnectorSoapBindingStub _stub = new AxisSOAPConnectorSoapBindingStub(new java.net.URL(AxisSOAPConnector_address), this);
                _stub.setPortName(getAxisSOAPConnectorWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new javax.xml.rpc.ServiceException(t);
        }
        throw new javax.xml.rpc.ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    /**
     * For the given interface, get the stub implementation.
     * If this service has no port for the given interface,
     * then ServiceException is thrown.
     */
    public java.rmi.Remote getPort(javax.xml.namespace.QName portName, Class serviceEndpointInterface) throws javax.xml.rpc.ServiceException {
        if (portName == null) {
            return getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("AxisSOAPConnector".equals(inputPortName)) {
            return getAxisSOAPConnector();
        }
        else  {
            java.rmi.Remote _stub = getPort(serviceEndpointInterface);
            ((org.apache.axis.client.Stub) _stub).setPortName(portName);
            return _stub;
        }
    }

    public javax.xml.namespace.QName getServiceName() {
        return new javax.xml.namespace.QName("urn:AxisSOAPConnector", "AxisSOAPConnectorService");
    }

    private java.util.HashSet ports = null;

    public java.util.Iterator getPorts() {
        if (ports == null) {
            ports = new java.util.HashSet();
            ports.add(new javax.xml.namespace.QName("AxisSOAPConnector"));
        }
        return ports.iterator();
    }

}
