/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.soap.axis;

import java.io.IOException;
import java.rmi.RemoteException;

import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;

/**
 * SOAP binding
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @author <a href="jhaynie@vocalcoity.net">Jeff Haynie</a>
 */
public class AxisSOAPConnectorSoapBindingImpl implements AxisSOAPConnector
{
    private ServerInvoker invoker;

    /**
     * server invoker will call invoke to pass a URI to himself
     */
    public void initialize(String invokerURI) throws java.rmi.RemoteException
    {
        ServerInvoker invokers[] = InvokerRegistry.getServerInvokers();
        if (invokers!=null)
        {
            for (int c=0;c<invokers.length;c++)
            {
                if (invokers[c].getLocator().getLocatorURI().equals(invokerURI))
                {
                    invoker = invokers[c];
                    break;
                }
            }
        }
        if (invoker==null)
        {
            throw new RemoteException("Couldn't find Invoker with URI: "+invokerURI);
        }
    }

    /**
     * This method is used to receive the client SOAP calls and pass them on to the
     * AxisSOAPConnectorServer via an MBeanServer transport call.  Will then return the
     * results to the calling SOAP client.
     *
     * @param data
     * @return byte array
     * @throws IOException
     * @throws java.rmi.RemoteException
     */
    public byte[] transport (byte[] data) throws IOException, java.rmi.RemoteException
    {
        if (invoker == null)
        {
            throw new IOException("AXIS Service hasn't been initialized");
        }
        return invoker.invoke(data);
    }




}
