/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.soap.axis;

import java.io.IOException;

/**
 * SOAP skeleton
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @author <a href="jhaynie@vocalcoity.net">Jeff Haynie</a>
 */
public class AxisSOAPConnectorSoapBindingSkeleton implements AxisSOAPConnector,
        org.apache.axis.wsdl.Skeleton
{
    private AxisSOAPConnector impl;
    private static java.util.Map _myOperations = new java.util.Hashtable();
    private static java.util.Collection _myOperationsList = new java.util.ArrayList();

    /**
    * Returns List of OperationDesc objects with this name
    */
    public static java.util.List getOperationDescByName(String methodName) {
        return (java.util.List)_myOperations.get(methodName);
    }

    /**
    * Returns Collection of OperationDescs
    */
    public static java.util.Collection getOperationDescs() {
        return _myOperationsList;
    }

    static {
        org.apache.axis.description.OperationDesc _oper;
        org.apache.axis.description.FaultDesc _fault;
        org.apache.axis.description.ParameterDesc [] _params;
        _params = new org.apache.axis.description.ParameterDesc [] {
            new org.apache.axis.description.ParameterDesc(new javax.xml.namespace.QName("", "in0"), org.apache.axis.description.ParameterDesc.IN, new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"), byte[].class, false, false),
        };
        _oper = new org.apache.axis.description.OperationDesc("transport", _params, new javax.xml.namespace.QName("", "invokeReturn"));
        _oper.setReturnType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        _oper.setElementQName(new javax.xml.namespace.QName("urn:AxisSOAPConnector", "transport"));
        _oper.setSoapAction("");
        _myOperationsList.add(_oper);
        if (_myOperations.get("transport") == null) {
            _myOperations.put("transport", new java.util.ArrayList());
        }
        ((java.util.List)_myOperations.get("transport")).add(_oper);
        _params = new org.apache.axis.description.ParameterDesc [] {
            new org.apache.axis.description.ParameterDesc(new javax.xml.namespace.QName("", "in0"), org.apache.axis.description.ParameterDesc.IN, new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"), String.class, false, false),
        };
        _oper = new org.apache.axis.description.OperationDesc("initialize", _params, null);
        _oper.setElementQName(new javax.xml.namespace.QName("urn:AxisSOAPConnector", "initialize"));
        _oper.setSoapAction("");
        _myOperationsList.add(_oper);
        if (_myOperations.get("initialize") == null) {
            _myOperations.put("initialize", new java.util.ArrayList());
        }
        ((java.util.List)_myOperations.get("initialize")).add(_oper);
        _params = new org.apache.axis.description.ParameterDesc [] {
            new org.apache.axis.description.ParameterDesc(new javax.xml.namespace.QName("", "in0"), org.apache.axis.description.ParameterDesc.IN, new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"), String.class, false, false),
        };
    }

    public AxisSOAPConnectorSoapBindingSkeleton() {
        this.impl = new AxisSOAPConnectorSoapBindingImpl();
    }

    public AxisSOAPConnectorSoapBindingSkeleton(AxisSOAPConnector impl) {
        this.impl = impl;
    }

    public byte[] transport (byte[] in0) throws IOException, java.rmi.RemoteException
    {
        return impl.transport(in0);
    }

    public void initialize(String in0) throws java.rmi.RemoteException
    {
        impl.initialize(in0);
    }


}
