/**
 * @(#)$Id: TransportTest.java,v 1.6 2003/12/16 04:58:07 telrod Exp $
 *
 * This code is PROPRIETARY AND CONFIDENTIAL to Vocalocity, Inc.
 * -- DO NOT RE-DISTRIBUTE THIS SOURCE CODE WITHOUT EXPRESS PERMISSION. --
 *
 * This source code is Copyright (c) 2003 by Vocalocity, Inc.
 * All Rights Reserved.
 *
 * The source code for this program is not published or
 * otherwise divested of its trade secrets, irrespective
 * of what has been deposited with the US Copyright Office.
 *
 */
package org.jboss.remoting.transport.test;

import java.io.ByteArrayInputStream;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.mock.MockClientInvoker;
import org.jboss.remoting.transport.mock.MockServerInvoker;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * TransportTest
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.6 $
 */
public class TransportTest
{
    public TransportTest (MBeanServer server, InvokerLocator locator)
        throws Throwable
    {
        InvokerRegistry.registerInvoker("mock",MockClientInvoker.class,MockServerInvoker.class);
        Connector connector = new Connector();
        StringBuffer buf=new StringBuffer();
        buf.append("<?xml version=\"1.0\"?>\n");
        buf.append("<handlers>\n");
        buf.append("  <handler subsystem=\"mock\">org.jboss.remoting.transport.mock.MockServerInvocationHandler</handler>\n");
        buf.append("</handlers>\n");
        Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
        connector.setInvokerLocator(locator.getLocatorURI());
        connector.setConfiguration((Element) xml);
        ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport="+locator.getProtocol());
        server.registerMBean(connector,obj);
        //connector.create();
        connector.start();

        System.out.println("Attempting to invoke test against: "+connector.getLocator());

        Client client = new Client(connector.getLocator(),"mock");
        // this should just echo back to us

        int MAX = 10000;
        long started = System.currentTimeMillis();
        for (int c=0;c<MAX;c++)
        {
           Object result = client.invoke(new NameBasedInvocation("test",new Object[]{"test"},new String[]{String.class.getName()}),null);
            if ("test".equals(result)==false)
            {
                throw new Exception("transport test failed - I sent 'test' and expected 'test' - but got back: "+result);
            }
        }
        System.out.println(MAX+" invokes took: "+((System.currentTimeMillis()-started)/1000)+" sec(s)");

        connector.stop();
        //connector.destroy();

        server.unregisterMBean(obj);
    }

    public static void main (String args[])
    {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try
        {
            InvokerLocator socketLocator=new InvokerLocator("socket://localhost");
            TransportTest test1=new TransportTest(server,socketLocator);

            InvokerLocator soapLocator=new InvokerLocator("soap://localhost");
            TransportTest test2=new TransportTest(server,soapLocator);

//            InvokerLocator rmiLocator=new InvokerLocator("rmi://localhost");
//            TransportTest test3=new TransportTest(server,rmiLocator);
        }
        catch (Throwable ex)
        {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}
