/**
 * @(#)$Id: OnewayInvokerServerTest.java,v 1.3 2003/12/16 06:54:11 telrod Exp $
 *
 * This code is PROPRIETARY AND CONFIDENTIAL to Vocalocity, Inc.
 * -- DO NOT RE-DISTRIBUTE THIS SOURCE CODE WITHOUT EXPRESS PERMISSION. --
 *
 * This source code is Copyright (c) 2003 by Vocalocity, Inc.
 * All Rights Reserved.
 *
 * The source code for this program is not published or
 * otherwise divested of its trade secrets, irrespective
 * of what has been deposited with the US Copyright Office.
 *
 */
package test;

import org.jboss.remoting.ServerInvocationHandler;
import org.apache.log4j.Level;
import test.performance.TestServerInvocationHandler;

/**
 * @author <a href="mailto:telrod@vocalocity.net">Tom Elrod</a>
 * @version $Revision: 1.3 $
 */
public class OnewayInvokerServerTest extends InvokerServerTest implements ShutdownListener
{
   public boolean timeToShutdown = false;

   private final Object waitObj = new Object();


   public OnewayInvokerServerTest(int instances)
   {
      super(instances);
   }

   public OnewayInvokerServerTest(String name)
   {
      super(name);
   }

   /**
    * Should be called when ready to shutdown.  Will notify all other remote test
    * instances and will then block until all other instances have made the same call.
    *
    * @throws Exception
    */
   public void shutdown() throws Exception
   {
      synchronized (waitObj)
      {
         try
         {
            waitObj.wait(10 * 60 * 1000); // timeout if not notified
         }
         catch (InterruptedException e)
         {
            System.out.println("Got interrupted exception.");
         }
      }
         super.shutdown();
   }

   public OnewayInvokerServerTest(String transport, int port)
   {
      super(transport, port);
   }

   public OnewayInvokerServerTest(String transport, int port, int instances)
   {
      super(transport, port, instances);
   }

   protected ServerInvocationHandler getServerInvocationHandler()
   {
      return new TestServerInvocationHandler(this);
   }

   protected String getSubsystem()
   {
      return "test";
   }

   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

      //DEBUG for server -TME
      System.setProperty("jboss.remoting.invoker.debug", "true");

      OnewayInvokerServerTest server = null;
      if (args.length == 1)
      {
         int instances = Integer.parseInt(args[0]);
         server = new OnewayInvokerServerTest(instances);
      }
      else if (args.length == 2)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         server = new OnewayInvokerServerTest(transport, port);
      }
      else if (args.length == 3)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         int instances = Integer.parseInt(args[2]);
         server = new OnewayInvokerServerTest(transport, port, instances);
      }
      else
      {
         server = new OnewayInvokerServerTest(InvokerServerTest.class.getName());
         System.out.println("Using default transport (" + server.getTransport() +
               ") and default port (" + server.getPort() + ") and " +
               "default number of instances (" + server.getNumberOfInstances() + ")" +
               "\nCan enter transport, port, and instances via command line.");
      }

      try
      {
         server.serverTest();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

   public void shutdownTest()
         throws Exception
   {
      synchronized (waitObj)
      {
         waitObj.notify();
      }
   }


}
