/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This should be used as the main test case for the oneway invoker client/server.
 * It will start one instance of the client and one of the server and will
 * gather the test results and report them in standard JUnit format.  When
 * wanting to run JUnit test for oneway invoker, this is the class to use.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class OnewayInvokerTestCase extends DistributedTestCase
{
   private List results = new ArrayList();

   public OnewayInvokerTestCase(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      String clientcmd = "java -cp " + System.getProperty("java.class.path") +
//                          " -Djboss.mx.instanceid.dir=" + System.getProperty("jboss.mx.instanceid.local.dir") +
            " " + OnewayInvokerClientTest.class.getName() + " 3";
      System.out.println("clientcmd: " + clientcmd);
      String svrcmd = "java -cp " + System.getProperty("java.class.path") +
//                          " -Djboss.mx.instanceid.dir=" + System.getProperty("jboss.mx.instanceid.remote.dir") +
            " " + InvokerServerTest.class.getName() + " 3";
      System.out.println("svrcmd: " + svrcmd);

      final Process local = Runtime.getRuntime().exec(clientcmd);
      final Process remote = Runtime.getRuntime().exec(svrcmd);

   }

   protected void tearDown() throws Exception
   {
      //NO OP since manually controlling shutdown
   }

   public void testInvokers()
   {
      try
      {
         startup(3);
         System.out.println("startup() called");
         shutdown();
         System.out.println("shutdown() called");
      }
      catch (Exception e)
      {
         //TODO:DEBUG -TME
         e.printStackTrace();
      }
      finally
      {
         // assert results
         try
         {
            Thread.currentThread().sleep(5000);
         }
         catch (InterruptedException e)
         {
            e.printStackTrace();
         }
         System.out.println("results.size() = " + results.size());
         if (results.size() > 0)
         {
            Iterator itr = results.iterator();
            while (itr.hasNext())
            {
               String message = (String) itr.next();
               assertTrue(message, false);
            }
         }
         else
         {
            assertTrue("No test failures or errors.", true);
         }

      }
   }

   /**
    * **********************************
    * Driver callback for JUnit asserts *
    * ***********************************
    */
   public void receiveAssert(Address source, String message)
   {
      super.receiveAssert(source, message);
      results.add("Assert source: " + source + "\tmessage: " + message);
   }

   public static Test suite()
   {
      return new TestSuite(OnewayInvokerTestCase.class);
   }

   public static void main(String[] args)
   {
      TestRunner.run(suite());
      System.exit(0);
   }


}