/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.classloading.server;

import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.mock.MockClientInvoker;
import org.jboss.remoting.transport.mock.MockServerInvocationHandler;
import org.jboss.remoting.transport.mock.MockServerInvoker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import test.AbstractInvokerTest;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Random;

/**
 * This is the concrete test for invoker server.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class InvokerServerNoSecurityTest extends AbstractInvokerTest
{
   private static final Logger log = Logger.getLogger(InvokerServerNoSecurityTest.class);

   public InvokerServerNoSecurityTest(String name)
   {
      super(name);
   }

   public InvokerServerNoSecurityTest(int instances)
   {
      super(InvokerServerNoSecurityTest.class.getName(), instances);
   }

   public InvokerServerNoSecurityTest(String transport, int port)
   {
      super(InvokerServerNoSecurityTest.class.getName(), transport, port);
   }

   public InvokerServerNoSecurityTest(String transport, int port, int instances)
   {
      super(InvokerServerNoSecurityTest.class.getName(), transport, port, instances);
   }

   public void init() throws Exception
   {
      if (port < 0)
      {
         port = Math.abs(new Random().nextInt(2000));
      }
      log.debug("port = " + port);

//      InvokerRegistry.registerInvoker("socket", SocketClientInvoker.class, SocketServerInvoker.class);
      InvokerRegistry.registerInvoker("mock", MockClientInvoker.class, MockServerInvoker.class);
      Connector connector = new Connector();
      InvokerLocator locator = new InvokerLocator(transport + "://localhost:" + port);
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.setConfiguration(getServerConfiguration());
      connector.start();
      //connector.addInvocationHandler(getSubsystem(), getServerInvocationHandler());
   }

   protected Element getServerConfiguration()
   {
      Element serverConfig = null;

      try
      {
         StringBuffer buf = new StringBuffer();
         buf.append("<?xml version=\"1.0\"?>\n");
         buf.append("<server_config>\n");
         buf.append("<classloading>\n");
         buf.append("<server-side>true</server-side>\n");
         buf.append("<client-side>true</client-side>\n");
         buf.append("</classloading>\n");
         buf.append("<handlers>\n");
         buf.append("<handler subsystem=\"mock\">org.jboss.remoting.transport.mock.MockServerInvocationHandler</handler>\n");
         buf.append("</handlers>");
         buf.append("</server_config>");
         System.out.println("Server config:\n" + buf);
         Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
         serverConfig = xml.getDocumentElement();
      }
      catch (SAXException e)
      {
         e.printStackTrace();
      }
      catch (IOException e)
      {
         e.printStackTrace();
      }
      catch (ParserConfigurationException e)
      {
         e.printStackTrace();
      }

      return serverConfig;
   }

   protected String getSubsystem()
   {
      return "mock";
   }

   protected ServerInvocationHandler getServerInvocationHandler()
   {
      return new MockServerInvocationHandler();
   }

   public void serverTest() throws Exception
   {
      try
      {
         init();
         startup(getNumberOfInstances());
         shutdown();
      }
      catch (Exception e)
      {
         log.error("Error in serverTest() of " + this.getClass().getName(), e);
         throw e;
      }
   }

   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

      //DEBUG for server -TME
      System.setProperty("jboss.remoting.invoker.debug", "true");

      InvokerServerNoSecurityTest server = null;
      if (args.length == 1)
      {
         int instances = Integer.parseInt(args[0]);
         server = new InvokerServerNoSecurityTest(instances);
      }
      else if (args.length == 2)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         server = new InvokerServerNoSecurityTest(transport, port);
      }
      else if (args.length == 3)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         int instances = Integer.parseInt(args[2]);
         server = new InvokerServerNoSecurityTest(transport, port, instances);
      }
      else
      {
         server = new InvokerServerNoSecurityTest(InvokerServerNoSecurityTest.class.getName());
         System.out.println("Using default transport (" + server.getTransport() +
               ") and default port (" + server.getPort() + ") and " +
               "default number of instances (" + server.getNumberOfInstances() + ")" +
               "\nCan enter transport, port, and instances via command line.");
      }

      try
      {
         server.serverTest();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

}
