/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting;

import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.mock.MockClientInvoker;
import org.jboss.remoting.transport.mock.MockServerInvoker;
import org.w3c.dom.Document;

import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;
import java.util.Random;

/**
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class InvokerServerUnitTestCase extends AbstractInvokerTest
{
    private static final Logger log = Logger.getLogger(InvokerServerUnitTestCase.class);

    public InvokerServerUnitTestCase(String name)
    {
        super(name);
    }

   public InvokerServerUnitTestCase(String name, String transport, int port)
   {
      super(name, transport, port);
    }

    public void init() throws Exception
    {
        if(port < 0)
        {
            port = Math.abs(new Random().nextInt(2000));
        }
        log.debug("port = " + port);

        InvokerRegistry.registerInvoker("mock", MockClientInvoker.class, MockServerInvoker.class);
        Connector connector = new Connector();
        InvokerLocator locator = new InvokerLocator(transport + "://localhost:" + port);
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\"?>\n");
        buf.append("<handlers>\n");
        buf.append("  <handler subsystem=\"mock\">org.jboss.remoting.transport.mock.MockServerInvocationHandler</handler>\n");
        buf.append("</handlers>\n");
        Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
        connector.setInvokerLocator(locator.getLocatorURI());
        connector.setConfiguration(xml.getDocumentElement());
        connector.start();
    }

    public void testServer() throws Exception
    {
       init();
    }
   /*
    public static void main(String[] args)
    {
        InvokerServerTest server = null;
        if(args.length == 1)
        {
            int instances = Integer.parseInt(args[0]);
            server = new InvokerServerTest(instances);
        }
        else if(args.length == 2)
        {
            String transport = args[0];
            int port = Integer.parseInt(args[1]);
            server = new InvokerServerTest(transport, port);
        }
        else if(args.length == 3)
        {
            String transport = args[0];
            int port = Integer.parseInt(args[1]);
            int instances = Integer.parseInt(args[2]);
            server = new InvokerServerTest(transport, port, instances);
        }
        else
        {
            server = new InvokerServerTest();
            System.out.println("Using default transport (" + server.getTransport() +
                               ") and default port (" + server.getPort() + ") and " +
                               "default number of instances (" + server.getNumberOfInstances() + ")" +
                               "\nCan enter transport, port, and instances via command line.");
        }

        try
        {
            server.serverTest();
        }
        catch(Exception e)
        {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
*/
}
