/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.detection.multicast;

import junit.framework.*;
import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;
import org.w3c.dom.Document;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;

/**
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @todo make this test actually work by starting another remoting
 * endpoint and making sure we are finding it.
 */
public class MulticastUnitTestCase extends TestCase
{

   public MulticastUnitTestCase(String name)
   {
      super(name);
   }

   public void testMulticast() throws Exception
   {

      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);
      Logger log = Logger.getLogger(getClass());

      System.setProperty("jboss.identity", String.valueOf(System.currentTimeMillis()));

      MBeanServer server = MBeanServerFactory.createMBeanServer();

      NetworkRegistry registry = NetworkRegistry.getInstance();
      server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));

      InvokerLocator locator = new InvokerLocator("socket://localhost");
      //ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
      //SocketServerInvoker invokerSvr = new SocketServerInvoker(clsLoader, locator);
      //ObjectName objName = new ObjectName("jboss.remoting:type=SocketServerInvoker");
      //server.registerMBean(invokerSvr, objName);
      //invokerSvr.start();

      Connector connector = new Connector();
      StringBuffer buf = new StringBuffer();
      buf.append("<?xml version=\"1.0\"?>\n");
      buf.append("<handlers>\n");
      buf.append("  <handler subsystem=\"mock\">org.jboss.remoting.transport.mock.MockServerInvocationHandler</handler>\n");
      buf.append("</handlers>\n");
      Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.setConfiguration(xml.getDocumentElement());
      ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator.getProtocol());
      server.registerMBean(connector, obj);
      //connector.create();
      connector.start();

      MulticastDetector detector = new MulticastDetector();
      server.registerMBean(detector, new ObjectName("remoting:type=Detector,transport=multicast"));
      detector.start();
      System.err.println("Starting MulticastDetector");

      while(true)
      {
         Thread.currentThread().sleep(3000);
         NetworkInstance[] instances = registry.getServers();
         for(int x = 0; x < instances.length; x++)
         {
            log.debug(instances[x]);
         }
         log.info("FIX THE MULTICAST TEST case!!");
         break;
      }


   }

}
