package org.jboss.jmx.adaptor.rmi;

import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.logging.Logger;

/** A delegate that sits between the local MBeanServer and the remote client
 * providing the RMINotificationListener.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.3 $
 */
public class NotificationListenerDelegate
   implements NotificationListener
{
   private static Logger log = Logger.getLogger(NotificationListenerDelegate.class);
   /** The remote client */
   private RMINotificationListener client;
   /** The server providing the RMIAdaptor interface */
   private RMIAdaptor server;
   /** The mbean the client is monitoring */
   private ObjectName targetName;

   public NotificationListenerDelegate(RMINotificationListener client)
   {
      this.client = client;
   }
   public NotificationListenerDelegate(RMINotificationListener client,
      ObjectName targetName, RMIAdaptor server)
   {
      this.client = client;
      this.targetName = targetName;
      this.server = server;
   }

   public void handleNotification(Notification notification,
      Object handback)
   {
      try
      {
         if( log.isTraceEnabled() )
         {
            log.trace("Sending notification to client, event:"+notification);
         }
         client.handleNotification(notification, handback);
      }
      catch(Throwable t)
      {
         log.debug("Failed to notify client", t);
         if( server != null )
         {
            log.debug("Unregistering listener due to previous error");
            try
            {
               server.removeNotificationListener(targetName, client);
            }
            catch(Exception e)
            {
               log.debug("Failed to unregister listener", e);
            }
         }
      }
   }
}
