/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.system;

/**
 * An extension of the ServiceMBean interface that provides for
 * declarative JMX notification subscription handling.
 * <p>
 * The SubscriptionList attribute is used to specify the list
 * of MBeans/notifications that the listener service instance
 * will subscribe for.
 * <p>
 * The abstract class ListenerServiceMBeanSupport implements
 * this interface.
 *
 * @see ServiceMBean
 * @see ListenerServiceMBeanSupport
 *
 * @author <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * @version $Revision: 1.1.2.2 $
**/
public interface ListenerServiceMBean
   extends ServiceMBean
{
   // Constants -----------------------------------------------------
  
   /** The XML subscription-list elements and attributes */
   public static final String SL_ROOT_ELEMENT                = "subscription-list";
   public static final String SL_MBEAN_ELEMENT               = "mbean";
   public static final String SL_NOTIFICATION_ELEMENT        = "notification";   
   public static final String SL_MBEAN_NAME_ATTRIBUTE        = "name";
   public static final String SL_MBEAN_HANDBACK_ATTRIBUTE    = "handback";
   public static final String SL_NOTIFICATION_TYPE_ATTRIBUTE = "type";
   
   // Public --------------------------------------------------------

   /**
    * Used to configure at start-up the JMX notification subscriptions.
    *
    * The configuration is done inline in the mbean descriptor. For example:
    *
    * <code>
    * ...
    * <attribute name="SubscriptionList">
    *   <subscription-list>
    *     <mbean name="jboss.system:*">
    *       <notification type="org.jboss.system.ServiceMBean.start"/>
    *       <notification type="org.jboss.system.ServiceMBean.stop"/>
    *     </mbean>
    *   </subscription-list>
    * </attribute>
    * ...
    * </code>
    *
    * See jboss-subscription.dtd
   **/
   public void setSubscriptionList(org.w3c.dom.Element list);
   
}
