package org.jboss.test;


import javax.naming.*;
import javax.management.*;
import java.util.*;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.apache.log4j.Category;


/** Helper Class that connects to the RMA Adaptor on any JBoss node
 *  to provide some services like start/stop JBoss services registered
 *  in the MBean server.
 *
 * @author Anil.Saldhana@jboss.org
 * @version $Revision: 1.1.2.1 $
 */

public class JBossRMIAdaptorHelper
{
    protected RMIAdaptor rmiserver = null;
    protected Category log;

    /**
     * Constructor
     */
    public JBossRMIAdaptorHelper()
    {
        log = Category.getInstance(this.getClass().getName());
    }

    /**
     * Constructor that takes a JNDI url
     * @param jndiurl    JNDI Url (jnp://localhost:1099)
     */
    public JBossRMIAdaptorHelper( String jndiurl ){
        this();
        try {
                //Set Some JNDI Properties
                Hashtable env = new Hashtable();
                env.put( Context.PROVIDER_URL, jndiurl );
                env.put( Context.INITIAL_CONTEXT_FACTORY, "org.jnp.interfaces.NamingContextFactory");
                env.put( Context.URL_PKG_PREFIXES, "org.jnp.interfaces");

	            InitialContext ctx = new InitialContext(env);
                rmiserver = (RMIAdaptor) ctx.lookup("jmx/rmi/RMIAdaptor");
                if( rmiserver == null ) log.debug( "RMIAdaptor is null");
        }catch( Exception e){
                 log.debug(e);
        }
    }

    /**
     * Get the Metadata for the MBean
     * @param oname   ObjectName of the MBean
     * @return  MBeanInfo about the MBean
     */
    public MBeanInfo getMBeanInfo( ObjectName oname ){
        /* Example:
           //Get the MBeanInfo for the Tomcat MBean
           ObjectName name = new ObjectName( "jboss.web:service=WebServer" );
        */
        MBeanInfo info = null;

        try{
             info = rmiserver.getMBeanInfo( oname );
        } catch( Exception e){
            log.debug(e);
        }
        return info;
    }

    /**
     * Invoke an Operation on the MBean
     * @param oname      ObjectName of the MBean
     * @param methodname Name of the operation on the MBean
     * @param pParams    Arguments to the operation
     * @param pSignature Signature for the operation.
     * @return   result from the MBean operation
     * @throws Exception
     */
    public Object invokeOperation( ObjectName oname,
                                   String methodname,Object[] pParams,
                                   String[] pSignature )
    throws Exception {
        Object result = null;
        try{
            /* Example:
            //Stop the Tomcat Instance
            Object result = server.invoke(name, "stop",null,null);
            */
             result = rmiserver.invoke(oname, methodname ,pParams,pSignature);
        } catch( Exception e){
            log.debug( e);
        }

        return  result;
    }


}//end class