package org.jboss.test.cache.test.eviction;

import junit.framework.TestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.eviction.EvictedEventNode;

import java.util.HashMap;

/**
 * @author Ben Wang, Feb 11, 2004
 */
public class RegionUnitTestCase extends TestCase
{
   RegionManager regionManager_;
   public RegionUnitTestCase(String s)
   {
      super(s);
   }

   public void setUp() throws Exception
   {
      super.setUp();
      regionManager_ = new RegionManager(null);
      regionManager_.createRegion("/a/b", null);
   }

   public void tearDown() throws Exception
   {
      super.tearDown();
   }

   public void testAddedQueue() {
      Fqn fqn1 = Fqn.fromString("/a/b/c");
      Fqn fqn2 = Fqn.fromString("/a/b/d");
      Fqn fqn3 = Fqn.fromString("/a/b/e");

      Region region = regionManager_.getRegion("/a/b");
      region.setAddedNode(fqn1);
      region.setAddedNode(fqn2);
      region.setAddedNode(fqn3);

      assertEquals("AddedNode queue size ", 3, region.nodeEventQueueSize());
      EvictedEventNode node = (EvictedEventNode)region.takeLastEventNode();
      Fqn fqn = node.getFqn();
      assertEquals("Node retrieved should be FILO ", fqn, fqn1);
      assertEquals("AddedNode queue size ", 2, region.nodeEventQueueSize());
      fqn = ((EvictedEventNode)region.takeLastEventNode()).getFqn();
      fqn = ((EvictedEventNode)region.takeLastEventNode()).getFqn();
      node = ((EvictedEventNode)region.takeLastEventNode());
      assertNull("Node should be null", node);
   }

   public void testEventQueue() {
      Fqn fqn1 = Fqn.fromString("/a/b/c");
      Fqn fqn2 = Fqn.fromString("/a/b/d");
      Fqn fqn3 = Fqn.fromString("/a/b/e");

      Region region = regionManager_.getRegion("/a/b");
      region.setRemovedNode(fqn1);
      region.setAddedNode(fqn2);
      region.setVisitedNode(fqn3);

      assertEquals("RemovedNode queue size ", 3, region.nodeEventQueueSize());
      Integer event = ((EvictedEventNode)region.takeLastEventNode()).getEvent();
      assertEquals("Node retrieved should be: ", EvictedEventNode.REMOVE_EVENT, event);
      Fqn fqn = ((EvictedEventNode)region.takeLastEventNode()).getFqn();
      fqn = ((EvictedEventNode)region.takeLastEventNode()).getFqn();
      EvictedEventNode node = ((EvictedEventNode)region.takeLastEventNode());
      assertNull("Node should be null", node);
   }

   void log(String msg)
   {
      System.out.println("-- " + msg);
   }

   public static Test suite()
   {
      return new TestSuite(RegionUnitTestCase.class);
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(suite());
   }

}
