/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.generic;


import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;

/**
 * @version $Revision: 1.1.2.6 $
 */
public class PropertyConfiguratorUnitTestCase extends TestCase
{

   public PropertyConfiguratorUnitTestCase(String s)
   {
      super(s);
   }

   public void setUp() throws Exception
   {
      super.setUp();
   }

   public void tearDown() throws Exception
   {
      super.tearDown();
   }

   public void testConfigure()
   {
      try {
         TreeCache cache = new TreeCache();
         PropertyConfigurator config = new PropertyConfigurator();
         config.configure(cache, "META-INF/local-service.xml");
         log("Cluster properties: " + cache.getClusterProperties());
      } catch (Exception ex) {
         ex.printStackTrace();
         fail(ex.toString());
      }
   }

   void log(String msg)
   {
      System.out.println("-- " + msg);
   }

   public static Test suite()
   {
      return new TestSuite(PropertyConfiguratorUnitTestCase.class);
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(suite());
   }

}
