/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.classloader.scoping.naming.service;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Attribute;

import org.jboss.mx.util.MBeanServerLocator;

/** A service that binds custom serializable objects into jndi for use by
 * a web app to test the behavior of jndi lookups across class loading
 * scopes.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 */
public class BindingService
{
   private String[] names = {"Name0", "Name1", "Name2"};
   private Boolean origCallByValue;

   public String[] getNames()
   {
      return names;
   }
   public void setNames(String[] names)
   {
      this.names = names;
   }

   public void start() throws Exception
   {
      // Put the NamingService into call by value mode
      MBeanServer server = MBeanServerLocator.locateJBoss();
      ObjectName namingService = new ObjectName("jboss:service=Naming");
      origCallByValue = (Boolean) server.getAttribute(namingService, "CallByValue");
      Attribute callByValue = new Attribute("CallByValue", Boolean.TRUE);
      server.setAttribute(namingService, callByValue);
      System.out.println("NamingService.CallByValue set to true");

      InitialContext ctx = new InitialContext();
      Context testCtx = ctx.createSubcontext("shared-context");
      System.out.println("Created shared-context");
      testCtx.bind("KeyCount", new Integer(names.length));
      System.out.println("Bound KeyCount");
      for(int n = 0; n < names.length; n ++)
      {
         String key = "Key#" + n;
         BindValue value = new BindValue();
         value.setValue("Value#"+n);
         testCtx.bind(key, value);
         System.out.println("Bound "+key);
      }
   }

   public void stop() throws Exception
   {
      MBeanServer server = MBeanServerLocator.locateJBoss();
      ObjectName namingService = new ObjectName("jboss:service=Naming");
      Attribute callByValue = new Attribute("CallByValue", origCallByValue);
      server.setAttribute(namingService, callByValue);
      System.out.println("NamingService.CallByValue restored to: "+origCallByValue);

      InitialContext ctx = new InitialContext();
      Context testCtx = (Context) ctx.lookup("shared-context");
      testCtx.unbind("KeyCount");
      System.out.println("Unbound KeyCount");
      for(int n = 0; n < names.length; n ++)
      {
         String key = "Key#" + n;
         testCtx.unbind(key);
         System.out.println("Unbound "+key);
      }
      ctx.unbind("shared-context");
      System.out.println("Destroyed shared-context");
   }
}
