/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cluster.apache_tomcat;

import junit.framework.Test;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossClusteredTestCase;

/**
 * Simple clustering test case of get/set.
 *
 * @author <a href="mailto:anil.saldhana@jboss.com">Anil Saldhana</a>.
 * @author Ben Wang
 * @version $Revision: 1.0
 */
public class SimpleTestCase
      extends BaseTest
{

   public SimpleTestCase(String name)
   {
      super(name);

   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(SimpleTestCase.class,
            "http-sr.war");
      return t1;
   }

   /**
    * Main method that deals with the Http Session Replication Test
    *
    * @throws Exception
    */
   public void testHttpSessionReplication()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testHttpSessionReplication");

      String apacheUrl = System.getProperty("apache.url");
      String urlname = apacheUrl + System.getProperty("apache.set.url");
      String geturlname = apacheUrl + System.getProperty("apache.get.url");

      getLog().debug(urlname + ":::::::" + geturlname);

// Create an instance of HttpClient.
      HttpClient client = new HttpClient();

// Set the session attribute first
      HttpMethod m1 = new GetMethod(urlname);
      makeGet(client, m1);
      sleepThread(4);

// Create a method instance.
      HttpMethod method = new GetMethod(geturlname);
//    Get the Attribute set by testsessionreplication.jsp
      attr = makeGet(client, method);

      restartTomcat(1);

//    Make connection and get
      method = new GetMethod(geturlname);
      String attr2 = makeGet(client, method);
      String tstr = "attr1=" + attr + " and attr2=" + attr2;

// Check the result
      if (!attr2.equals(attr)) fail("Http Session Replication failed with " + tstr);
      getLog().debug("Http Session Replication has happened");
      getLog().debug("Exit testHttpSessionReplication");
   }


}
