package org.jboss.test.cluster.web;

import javax.servlet.http.HttpSessionListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSession;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revison:$
 */
public class SessionListener
   implements HttpSessionListener, HttpSessionActivationListener
{
   public void sessionCreated(HttpSessionEvent event)
   {
      HttpSession session = event.getSession();
      System.out.println("SessionListener.sessionCreated, id="+session.getId());
      session.setAttribute("SessionListener", this.toString());
   }

   public void sessionDestroyed(HttpSessionEvent event)
   {
      HttpSession session = event.getSession();
      System.out.println("SessionListener.sessionDestroyed, id="+session.getId());
   }

   public void sessionWillPassivate(HttpSessionEvent event)
   {
      HttpSession session = event.getSession();
      System.out.println("SessionListener.sessionWillPassivate, id="+session.getId());
   }

   public void sessionDidActivate(HttpSessionEvent event)
   {
      HttpSession session = event.getSession();
      System.out.println("SessionListener.sessionDidActivate, id="+session.getId());
   }
}
