/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cmp2.enum.ejb;

import org.jboss.ejb.plugins.cmp.jdbc.Mapper;

import java.io.Serializable;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision: 1.1.2.1 $</tt>
 */
public class IDClass
   implements Serializable, Mapper
{
   public long id;

   public IDClass()
   {
   }

   public IDClass(long id)
   {
      this.id = id;
   }

   public long getId()
   {
      return id;
   }

   public void setId(long id)
   {
      this.id = id;
   }

   public boolean equals(Object o)
   {
      if(this == o) return true;
      if(!(o instanceof IDClass)) return false;

      final IDClass idClass = (IDClass) o;

      if(id != idClass.id) return false;

      return true;
   }

   public int hashCode()
   {
      return (int) (id ^ (id >>> 32));
   }

   public String toString()
   {
      return "[" + id + ']';
   }

   // Mapper implementation

   public Object toColumnValue(Object fieldValue)
   {
      return fieldValue == null ? null : new Long(((IDClass)fieldValue).id);
   }

   public Object toFieldValue(Object columnValue)
   {
      return columnValue == null ? null : new IDClass(((Long)columnValue).longValue());
   }
}
