/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.test.cmp2.optimisticlock.bug1006723.testentity;

import javax.ejb.EntityBean;
import javax.ejb.CreateException;
import javax.ejb.EntityContext;
import java.util.Date;

public abstract class EntityBBean implements EntityBean{

	public Long getOID(){
    	return getOIDCMP();
	}

	public void setLastModified(Date date) throws Exception{
    	if (date == null)
			throw new Exception("A date must be specified!");
		setLastModifiedCMP(date.getTime());
	}

	public abstract void setOIDCMP(Long oID);

	public abstract Long getOIDCMP();

	public abstract void setLastModifiedCMP(long date);

	public abstract long getLastModifiedCMP();

	public Long ejbCreate(Long id) throws CreateException{
		setOIDCMP(id);
		return id;
	}

	public void ejbPostCreate(Long id) throws CreateException{}

	public void ejbActivate(){}

	public void ejbPassivate(){}

	public void ejbLoad(){}

	public void ejbStore(){}

	public void ejbRemove(){}

	public void setEntityContext(EntityContext context){}

	public void unsetEntityContext(){}

}