/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.ha.jmx.test;

import javax.management.Notification;

import junit.framework.TestCase;

import org.jboss.test.ha.jmx.HAServiceMBeanSupportTester;

/**
 * 
 * @author Ivelin Ivanov <ivelin@jboss.org>
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.2 $
 */
public class HAServiceMBeanSupportUnitTestCase extends TestCase
{

  private HAServiceMBeanSupportTester haServiceMBeanSupportTester_ = null;

  public HAServiceMBeanSupportUnitTestCase(String name)
  {
    super(name);
  }
   
  public void setUp()
  {
    haServiceMBeanSupportTester_ = new HAServiceMBeanSupportTester();
  }

  
  public void tearDown() 
  {
    haServiceMBeanSupportTester_ = null;
  }


  /**
   * 
   * messages should be sent out to both remote and local listeners.
   *
   */
  public void testSendNotificationBroadcastsToClusterAndLocally()
  {
    Notification notification = new Notification("test.notification", "some:name=tester", 1);
    haServiceMBeanSupportTester_.sendNotification( notification );

    assertEquals("sendNotificationToLocalListeners() was not handed the original notification", 
      haServiceMBeanSupportTester_.__invokationStack__.pop(), notification );

    assertEquals("method not invoked as expected",
      haServiceMBeanSupportTester_.__invokationStack__.pop(), "sendNotificationToLocalListeners");      

    assertEquals("sendNotificationRemote() was not handed the original notification", 
      haServiceMBeanSupportTester_.__invokationStack__.pop(), notification );
    
    assertEquals("method not invoked as expected",
      haServiceMBeanSupportTester_.__invokationStack__.pop(), "sendNotificationRemote");      
  }

  /**
   * 
   * Even if the message cannot be sent out to the cluster,
   * it should still be delivered to local listeners.
   *
   */
  public void testSendNotificationAfterClusterFailureContinueWithLocal()
  {
    haServiceMBeanSupportTester_.__shouldSendNotificationRemoteFail__ = true;

    Notification notification = new Notification("test.notification", "some:name=tester", 1);
    haServiceMBeanSupportTester_.sendNotification( notification );
    
    assertEquals("sendNotificationToLocalListeners() was not handed the original notification", 
    haServiceMBeanSupportTester_.__invokationStack__.pop(), notification );

    assertEquals("method not invoked as expected",
      haServiceMBeanSupportTester_.__invokationStack__.pop(), "sendNotificationToLocalListeners");      
  }

}
