/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.hibernate;

import org.jboss.test.hibernate.model.User;
import org.jboss.hibernate.session.HibernateContext;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;

import java.util.List;

/**
 * A service bean used to interact with a bound hibernate session for
 * testing purposes.
 *
 * @author <a href="mailto:steve@hibernate.org">Steve Ebersole</a>
 * @version $Revision: 1.1.2.2 $
 */
public class ProfileService
{
   private static final String SESSION_FACTORY_NAME = "java:/hibernate/SessionFactory";

   public User loadUser(long id) throws HibernateException
   {
      return loadUser( new Long(id) );
   }

   public User loadUser(Long id) throws HibernateException
   {
      return (User) getSession().load(User.class, id);
   }

   public List listUsers() throws HibernateException
   {
      return getSession()
            .createQuery("from User")
            .list();
   }

   public User locateUser(String handle) throws HibernateException
   {
      return (User) getSession()
            .createQuery("from User as u where u.handle = :handle")
            .setString("handle", handle)
            .uniqueResult();
   }

   public User storeUser(User user) throws HibernateException
   {
      getSession().saveOrUpdate(user);
      getSession().flush();
      return user;
   }

   private Session getSession()
   {
      return HibernateContext.getSession(SESSION_FACTORY_NAME);
   }
}
