//$Id: Role.java,v 1.1.2.1 2004/07/29 05:30:21 steveebersole Exp $
package org.jboss.test.hibernate.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * @author Gavin King
 */
public class Role implements Serializable {
	private Long id;
	private String name;
	private String description;
	private Calendar timeOfCreation;
	private List users= new ArrayList();
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Long getId() {
		return id;
	}

	private void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public List getUsers() {
		return users;
	}

	private void setUsers(List users) {
		this.users = users;
	}
	
	public void addUser(User user) {
		users.add(user);
		user.getRoles().add(this);
	}

	public Calendar getTimeOfCreation() {
		return timeOfCreation;
	}

	public void setTimeOfCreation(Calendar timeOfCreation) {
		this.timeOfCreation = timeOfCreation;
	}
	
	//it is best to implement equals()/hashCode()
	//to compare a "business key" (in this case
	//the unique name of the Role) rather than
	//the surrogate id
	
	public boolean equals(Object other) {
		if (other==null) return false;
		if ( !(other instanceof Role) ) return false;
		return ( (Role) other ).getName().equals(name);
	}
	
	public int hashCode() {
		return name.hashCode();
	}

}

