//$Id: UserRole.java,v 1.1.2.1 2004/07/29 05:30:21 steveebersole Exp $
package org.jboss.test.hibernate.model;

import java.io.Serializable;
import java.util.Calendar;

/**
 * Association class for the many-to-many assocition
 * from User to Role.
 * 
 * @author Gavin King
 */
public class UserRole implements Serializable {
	private User user;
	private Role role;
	private Calendar timeOfCreation;
	
	private UserRole() {}
	
	public UserRole(User user, Role role) {
		this.user = user;
		this.role = role;
		this.timeOfCreation = Calendar.getInstance();
	}
	
	public Role getRole() {
		return role;
	}

	public void setRole(Role role) {
		this.role = role;
	}

	public Calendar getTimeOfCreation() {
		return timeOfCreation;
	}

	public void setTimeOfCreation(Calendar timeOfCreation) {
		this.timeOfCreation = timeOfCreation;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

}

