// $Id: HibernateIntgUnitTestCase.java,v 1.2.2.1 2004/10/28 19:46:37 steveebersole Exp $
package org.jboss.test.hibernate.test;

import org.jboss.test.JBossTestCase;
import org.jboss.test.hibernate.model.User;
import org.jboss.test.hibernate.model.Name;
import org.jboss.test.hibernate.ejb.interfaces.ProfileService;
import org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome;
import org.jboss.test.hibernate.ejb.interfaces.ProfileServiceUtil;

import java.util.GregorianCalendar;
import java.util.List;
import java.util.Iterator;

import junit.framework.Test;

/**
 * Implementation of HibernateIntgUnitTestCase.
 *
 * @author Steve Ebersole
 */
public class HibernateIntgUnitTestCase extends JBossTestCase
{
   public HibernateIntgUnitTestCase(String name) throws Exception
   {
      super(name);
   }

   /** Setup the test suite.
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(HibernateIntgUnitTestCase.class, "hib-test.ear");
   }

   public void testEjbInterception() throws Throwable {
      // A simple test to ensure the session gets bound as part of the
      // interceptor
      getLog().debug("Starting hibernate ejb interceptor test case");

      User user = new User();
      user.setEmail("nobody@nowhere.com");
      user.setName( new Name() );
      user.getName().setFirstName("John");
      user.getName().setInitial( new Character('Q') );
      user.getName().setLastName("Public");
      user.setPassword("password");
      user.setTimeOfCreation( new GregorianCalendar() );
      user.setHandle("myHandle");

      ProfileServiceHome home = ProfileServiceUtil.getHome();
      ProfileService service = home.create();

      Long savedUserId = service.storeUser(user).getId();
      getLog().info("User created with id = " + savedUserId );

      List users = service.listUsers();
      getLog().debug("user list = " + users);
      if (users == null || users.isEmpty())
      {
         getLog().info("No users returned in list");
      }
      else
      {
         Iterator itr = users.iterator();
         while ( itr.hasNext() )
         {
            getLog().info("List returned user w/ id = " + ( (User) itr.next() ).getId() );
         }
      }

      user = service.loadUser(savedUserId);
      assertNotNull(user);
   }

}
