/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.invokers.interfaces;

import javax.ejb.*;
import java.rmi.*;

/** The interface representing the remotely invocable business methods.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1 $
 */
public interface BusinessObject extends EJBObject
{
   public boolean doSomething() throws RemoteException;
   /** A long running business method that is inteded to be invoked
    * asynchronously via the JMSGatewayMDB.
    * 
    * @return the result of the long operation
    */ 
   public String doSomethingSlowly(Object arg1, String arg2) throws RemoteException;
}
