/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.isolation.web.c;

import javax.servlet.ServletContextListener;
import javax.servlet.ServletContextEvent;

import org.apache.log4j.Logger;

/** 
 * A ContextListener.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1.2.1 $
 */
public class ContextListener implements ServletContextListener
{
   private static final Logger log = Logger.getLogger(ContextListener.class);

   static
   {
      test();
   }
   
   public void contextInitialized(ServletContextEvent e)
   {
      test();
   }

   public void contextDestroyed(ServletContextEvent e)
   {
   }

   protected static void test()
   {
      dump("TCL=", Thread.currentThread().getContextClassLoader());
      dump("MyCL=", ContextListener.class.getClassLoader());
      dump("LoggerCL=", log.getClass().getClassLoader());
      
      if (ContextListener.class.getClassLoader() != log.getClass().getClassLoader())
         throw new RuntimeException("Expected log4j logger to be from same classloader");
   }
   
   protected static void dump(String context, ClassLoader cl)
   {
      System.out.println(context + cl);
   }
}
