/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jbossnet.admindevel;


import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import java.rmi.RemoteException;

/**
 * The typical Hello Session Bean this time
 * as a web-service.
 * @author jung
 * @version $Revision: 1.1.4.1 $
 * @ejb:bean name="Hello"
 *           display-name="Hello World Bean"
 *           type="Stateless"
 *           view-type="remote"
 *           jndi-name="Hello"
 * @ejb:transaction type="Required"
 * @jboss-net:web-service urn="Hello"
 */
public class HelloBean implements javax.ejb.SessionBean
{
   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="remote"
    */
   public String helloString(String name)
   {
      return "Hello " + name + "!";
   }

   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="remote"
    */
   public HelloReplyObj helloBean(HelloObj bean)
   {
      HelloReplyObj hro = new HelloReplyObj();
      hro.setMsg(helloString(bean.getMsg()));
      return hro;
   }

   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="remote"
    */
   public Object[] helloArray(Object[] query)
   {
      Object[] reply = new Object[query.length];
      for (int n = 0; n < query.length; n++)
      {
         HelloObj hello = (HelloObj)query[n];
         HelloReplyObj hro = new HelloReplyObj();
         hro.setMsg(helloString(hello.getMsg()));
         reply[n] = hro;
      }
      return reply;
   }

   public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException
   {
   }

   public void ejbCreate()
   {
   }

   public void ejbRemove()
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }
}
