/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: EJBEndpointTestCase.java,v 1.1.4.2 2004/12/02 11:40:15 tdiesler Exp $

package org.jboss.test.jbossnet.ejbsimple;

import junit.framework.Test;
import org.jboss.test.jbossnet.JBossNetTestBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import java.net.URL;
import java.util.Arrays;

/**
 * Tests remote accessibility of stateless ejb bean
 * @since 5. Oktober 2001, 12:11
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @author Adrian Brock
 * @author Thomas.Diesler@jboss.org
 * @version $Revision: 1.1.4.2 $
 */

public class EJBEndpointTestCase extends JBossNetTestBase
{
   private QName HELLO_REMOTE_SERVICE = new QName("http://" + getServerHost() + ":8080/jboss-net/services/HelloRemote", "HelloRemoteService");
   private QName HELLO_LOCAL_SERVICE = new QName("http://" + getServerHost() + ":8080/jboss-net/services/HelloLocal", "HelloLocalService");

   // Constructors --------------------------------------------------
   public EJBEndpointTestCase(String name)
   {
      super(name);
   }

   /** the session beans with which we interact */
   HelloRemote hello;
   HelloRemote helloLocal;

   /** setup the bean */
   public void setUp() throws Exception
   {
      super.setUp();
      URL wsdlURL = new URL(SERVICES_LOCATION + "/HelloRemote?wsdl");
      hello = (HelloRemote)createService(wsdlURL, HELLO_REMOTE_SERVICE).getPort(HelloRemote.class);
      wsdlURL = new URL(SERVICES_LOCATION + "/HelloLocal?wsdl");
      helloLocal = (HelloRemote)createService(wsdlURL, HELLO_LOCAL_SERVICE).getPort(HelloRemote.class);
   }

   /** where the config is stored */
   protected String getAxisConfiguration()
   {
      return "jbossnet/ejbsimple/client/client-config.wsdd";
   }

   /** Make sure we have the xerces parser, otherwise element serialization might fail */
   public void testClientParser() throws Exception
   {
      DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
      assertEquals("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl", docFactory.getClass().getName());
   }

   /** test a simple hello world */
   public void testHello() throws Exception
   {
      assertEquals("Hello World!", hello.hello("World"));
      assertEquals("Hello World!", helloLocal.hello("World"));
   }

   /** test some structural parameters */
   public void testHowdy() throws Exception
   {
      HelloData data = new HelloData();
      data.setName("CGJ");
      assertEquals("Howdy CGJ!", hello.howdy(data));
      assertEquals("Howdy CGJ!", helloLocal.howdy(data));
   }

   /** arrays should be tested too */
   public void testTypedArrays() throws Exception
   {
      HelloData[] values = new HelloData[]{new HelloData(), new HelloData()};
      assertTrue(Arrays.equals(hello.typedArrays(values), values));
      assertTrue(Arrays.equals(helloLocal.typedArrays(values), values));
   }

   /** arrays should be tested too */
   public void testArrays() throws Exception
   {
      Object[] values = new Object[]{new String("Test"), new Integer(1), new HelloData()};
      assertTrue(Arrays.equals(hello.arrays(values), values));
      assertTrue(Arrays.equals(helloLocal.arrays(values), values));
   }

   /** order preservation ok ? */
   public void testReverse() throws Exception
   {
      Object[] values = new Object[]{new String("Test"), new Integer(1), new HelloData()};
      Object[] expected = new Object[]{new HelloData(), new Integer(1), new String("Test")};
      assertTrue(Arrays.equals(hello.reverse(values), expected));
      assertTrue(Arrays.equals(helloLocal.reverse(values), expected));
   }

   /** order preservation ok ? */
   public void testElement() throws Exception
   {
      DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
      Document doc = docFactory.newDocumentBuilder().newDocument();
      Element testElement = doc.createElement("TestElement");
      assertEquals(testElement.getNodeName(), hello.element(testElement).getNodeName());
      assertEquals(testElement.getNodeName(), helloLocal.element(testElement).getNodeName());
   }

   /** this is to deploy the whole ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(EJBEndpointTestCase.class, "jbossnet-ejbsimple.ear");
   }

   /** standalone */
   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(EJBEndpointTestCase.class);
   }

}
