/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: ExternalUnitTestCase.java,v 1.1.1.1.4.4 2004/12/02 11:40:16 tdiesler Exp $

package org.jboss.test.jbossnet.external;

import junit.framework.Test;
import org.jboss.test.jbossnet.JBossNetTestBase;

import javax.xml.namespace.QName;
import java.net.URL;

/**
 * tests connectivity to external, global web services.
 * @author cgjung
 * @author Thomas.Diesler@jboss.org
 * @since 10.2002
 */
public class ExternalUnitTestCase extends JBossNetTestBase
{
   private QName FEDERATED_SERVICE = new QName("http://" + getServerHost() + ":8080/jboss-net/services/FederatedService", "FederatedServiceLocalService");

   // Constructors --------------------------------------------------
   public ExternalUnitTestCase(String name)
   {
      super(name);
   }

   /** the session bean with which we interact */
   FederatedService federation;

   /** setup the bean */
   public void setUp() throws Exception
   {
      super.setUp();
      URL wsdlURL = new URL(SERVICES_LOCATION + "/FederatedService?wsdl");
      federation = (FederatedService)createService(wsdlURL, FEDERATED_SERVICE).getPort(FederatedService.class);
   }

   /** test a federated call */
   public void testFederated() throws Exception
   {
      String result = federation.findAndTranslate("JBoss is a killer server and Mr. Fleury is a damned genius");
      assertNotNull("Result is null", result);
      System.out.println("Result: " + result);
      String shittimes = "This service is currently disabled.";
      assertTrue(result, result.indexOf("JBoss") >= 0 || shittimes.equals(result));
   }

   /** where the config is stored */
   protected String getAxisConfiguration()
   {
      return "jbossnet/external/client/client-config.wsdd";
   }

   /** this is to deploy the whole ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ExternalUnitTestCase.class, "jbossnet-external.ear");
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(ExternalUnitTestCase.class);
   }
}
