/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: FederatedServiceBean.java,v 1.1.1.1.4.1 2004/08/09 09:54:35 tdiesler Exp $

package org.jboss.test.jbossnet.external.server;

import java.rmi.RemoteException;

import javax.ejb.SessionBean;

import org.jboss.test.util.ejb.SessionSupport;
import org.jboss.test.jbossnet.external.google.GoogleSearchPort;
import org.jboss.test.jbossnet.external.google.GoogleSearchService;
import org.jboss.test.jbossnet.external.google.GoogleSearchResult;

import org.jboss.test.jbossnet.external.babelfish.BabelFishPortType;
import org.jboss.test.jbossnet.external.babelfish.BabelFishService;
import org.jboss.logging.Logger;

import javax.naming.InitialContext;

/**
 * implementation of a federated ejb service making
 * use of external web services bound in the JNDI tree.
 * @version 	1.0
 * @author cgjung
 * @ejb.bean name="FederatedService"
 *           display-name="Federated Service"
 *           type="Stateless"
 *           view-type="both"
 *           jndi-name="FederatedService"
 *           local-jndi-name="FederatedServiceLocal"
 * @ejb.transaction type="Required"
 * @jboss-net.web-service urn="FederatedService"
 * @ejb.interface remote-class="org.jboss.test.jbossnet.external.FederatedService" local-class="org.jboss.test.jbossnet.external.server.FederatedServiceLocal" extends="javax.ejb.EJBObject" local-extends="javax.ejb.EJBLocalObject"
 * @ejb.home remote-class="org.jboss.test.jbossnet.external.FederatedServiceHome" local-class="org.jboss.test.jbossnet.external.server.FederatedServiceHomeLocal" extends="javax.ejb.EJBHome" local-extends="javax.ejb.EJBLocalHome"
 */

public class FederatedServiceBean extends SessionSupport implements SessionBean
{
   private static Logger log = Logger.getLogger(FederatedServiceBean.class);

   /** 
    * first accesses google to produce a set of
    * search results and then connects to babelfish
    * to translate the content of the title of 
    * one of them
    * @jboss-net.web-method
    * @ejb.interface-method view-type="both"
    */

   public String findAndTranslate(String searchTerm) throws Exception
   {
      // look into JNDI
      InitialContext initContext = new InitialContext();

      // find external references there
      GoogleSearchService googleService =
         (GoogleSearchService) initContext.lookup("Google");
      GoogleSearchPort google = googleService.getGoogleSearchPort();

      String licenseKey =
         System.getProperty(
            "google.license",
            "Wr5iTf5QFHJKmmnJn+61lt9jaMuWMKCj");

      GoogleSearchResult searchResult =
         google.doGoogleSearch(
            licenseKey,
            searchTerm,
            0,
            10,
            true,
            "",
            false,
            "",
            "latin1",
            "latin1");

      log.debug("Query for: '" + searchTerm + "' returned: " + searchResult);

      BabelFishService babelFishService =
         (BabelFishService) initContext.lookup("BabelFish");

      BabelFishPortType babelFish = babelFishService.getBabelFishPort();

      // and call them
      try
      {
         String translationResult = babelFish.babelFish("en_de", searchTerm);
         log.debug(
            "Translation of: '"
               + searchTerm
               + "' returned: "
               + translationResult);
         return translationResult;
      } catch (RemoteException e)
      {
         // sometimes babelfish is down
         return "This service is currently disabled.";
      }

   }

}
