/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: WSRUnitTestCase.java,v 1.1.1.1.4.2 2004/11/05 18:18:21 tdiesler Exp $

package org.jboss.test.jbossnet.wsr;

import com.ibm.wsdl.factory.WSDLFactoryImpl;
import junit.framework.Test;
import org.jboss.test.jbossnet.JBossNetTestBase;
import org.xml.sax.InputSource;

import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import java.io.InputStream;
import java.net.URL;

/**
 * Tests remote accessibility of "ordinary" (wsr-) deployed Axis services
 * @since 11. Oktober 2001
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @version $Revision: 1.1.1.1.4.2 $
 */
public class WSRUnitTestCase extends JBossNetTestBase
{
   private QName ADDRESS_SERVICE = new QName("http://test.jboss.org/samples/AddressBook", "AddressBookService");

   // Constructors --------------------------------------------------
   public WSRUnitTestCase(String name)
   {
      super(name);
   }

   /** prepared data */
   Address address;
   AddressBook book;

   /** sets up the test */
   public void setUp() throws Exception
   {
      super.setUp();

      Phone phone = new Phone();
      phone.setExchange("(0)6897");
      phone.setNumber("6666");
      phone.setAreaCode(49);
      StateType state = StateType.fromString("TX");
      address = new Address();
      address.setStreetNum(42);
      address.setStreetName("Milky Way");
      address.setCity("Galactic City");
      address.setZip(2121);
      address.setState(state);
      address.setPhoneNumber(phone);

      URL wsdlURI = new URL(SERVICES_LOCATION + "/AddressBook?wsdl");
      Service service = createService(wsdlURI, ADDRESS_SERVICE, true);

      book = (AddressBook)service.getPort(AddressBook.class);
   }

   /** this is where the axis config is stored */
   protected String getAxisConfiguration()
   {
      return "jbossnet/wsr/client/client-config.wsdd";
   }

   /** routes an address to the server and tests the result */
   public void testAddress() throws Exception
   {
      book.addEntry("George", address);
      Address retAddress = book.getAddressFromName("George");
      assertEquals("Comparing addresses", address, retAddress);
   }

   /** suite method */
   public static Test suite() throws Exception
   {
      return getDeploySetup(WSRUnitTestCase.class, "jbossnet-wsr.wsr");
   }
}